//
//  MCGlobalHotKeyRegistry.h
//  GlobalShortcutManager
//
//  Created by Ali Lalani on 1/29/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#include <Carbon/Carbon.h>

@interface MCGlobalHotKeyRegistry : NSObject {
	NSMutableArray *_hotKeys;
}

+ (MCGlobalHotKeyRegistry *)defaultRegistry;

// REGISTRATION
- (BOOL)registerHotKeyWithIdentifier:(NSString *)anIdentifier
					   modifierFlags:(unsigned int)modifierFlags
							 keyCode:(unsigned short)keyCode
							   chars:(NSString *)chars
							  target:(id)target
							selector:(SEL)selector;
- (void)unregisterHotKeyWithIdentifier:(NSString *)anIdentifier;

// UTILITIES //
- (UInt32)carbonModifiersForCocoaModifiers:(unsigned int)mods;
- (void)handleHotKeyEvent:(EventRef)theEvent;
- (NSString *)stringRepresentationForEvent:(NSEvent *)event;
- (NSString *)stringRepresentationForModifierFlags:(unsigned int)mods
										characters:(NSString *)chars;
// ACCESSORS //
- (NSMutableArray *)hotKeys;
- (NSMutableDictionary *)hotKeyWithIdentifier:(NSString *)anIdentifier;
@end
